package gov.va.med.mhv.vitals.dto;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.mhv.vitals.enums.PainLevelEnumeration;

@XmlRootElement(name = "PainReadingDTO")
public class PainReadingDTO extends AbstractDTO implements Serializable{
	
	private static final long serialVersionUID = -6699885612022339925L;
	
	private static final Map<Integer, PainLevelEnumeration> PAIN_LEVEL_MAP = new HashMap<>(11);
	
	static {
		PAIN_LEVEL_MAP.put(0, PainLevelEnumeration.ZERO);
		PAIN_LEVEL_MAP.put(1, PainLevelEnumeration.ONE);
		PAIN_LEVEL_MAP.put(2, PainLevelEnumeration.TWO);
		PAIN_LEVEL_MAP.put(3, PainLevelEnumeration.THREE);
		PAIN_LEVEL_MAP.put(4, PainLevelEnumeration.FOUR);
		PAIN_LEVEL_MAP.put(5, PainLevelEnumeration.FIVE);
		PAIN_LEVEL_MAP.put(6, PainLevelEnumeration.SIX);
		PAIN_LEVEL_MAP.put(7, PainLevelEnumeration.SEVEN);
		PAIN_LEVEL_MAP.put(8, PainLevelEnumeration.EIGHT);
		PAIN_LEVEL_MAP.put(9, PainLevelEnumeration.NINE);
		PAIN_LEVEL_MAP.put(10, PainLevelEnumeration.TEN);
	}
	
    private Long painId;
	private String comments;
	private PainLevelEnumeration painLevel = PainLevelEnumeration.ZERO;
	private Long userprofileId;
	
	public Long getPainId() {
		return painId;
	}
	public void setPainId(Long painId) {
		this.painId = painId;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public Integer getPainLevel() {
		return painLevel.getValue();
	}
	public void setPainLevel(Integer painLevel) {
		this.painLevel = PAIN_LEVEL_MAP.get(painLevel);
	}
	public Long getUserprofileId() {
		return userprofileId;
	}
	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}
	
	@JsonIgnore
	public String getDisplayPainLevel() {
		return this.painLevel.getDescription();
	}
	
	@JsonIgnore
	public PainLevelEnumeration[] getPainLevels() {
		return PainLevelEnumeration.values();
	}
}
